import xlsxwriter


workbook = xlsxwriter.Workbook('ResultsObstacle.xlsx')
worksheet = workbook.add_worksheet()
worksheet.write(0, 0, "Frame")
worksheet.write(0, 1, "Predicted Obstacle")
worksheet.write(0, 2, "Logic Obstacle")
worksheet.write(0, 3, "Actual Obstacle")
worksheet.write(0, 4, "Combined Obstacle")

worksheet.write(0, 9, "none\n")
worksheet.write(0, 10, "Logical Accuracy")
worksheet.write(0, 11, "accuracy")
worksheet.write(0, 12, "precision")
worksheet.write(0, 13, "recall")
worksheet.write(0, 14, "f-score")
worksheet.write(0, 15, "true negative")
worksheet.write(0, 16, "true positive")
worksheet.write(0, 17, "false negative")
worksheet.write(0, 18, "false positive")

worksheet.write(3, 10, "Baseline Accuracy")
worksheet.write(3, 11, "accuracy")
worksheet.write(3, 12, "precision")
worksheet.write(3, 13, "recall")
worksheet.write(3, 14, "f-score")
worksheet.write(3, 15, "true negative")
worksheet.write(3, 16, "true positive")
worksheet.write(3, 17, "false negative")
worksheet.write(3, 18, "false positive")

worksheet.write(6, 10, "Combined Accuracy")
worksheet.write(6, 11, "accuracy")
worksheet.write(6, 12, "precision")
worksheet.write(6, 13, "recall")
worksheet.write(6, 14, "f-score")
worksheet.write(6, 15, "true negative")
worksheet.write(6, 16, "true positive")
worksheet.write(6, 17, "false negative")
worksheet.write(6, 18, "false positive")

worksheet.write(1, 11, "=(P2+Q2)/(P2+Q2+R2+S2)")
worksheet.write(1, 12, "=Q2/(Q2+S2)")
worksheet.write(1, 13, "=Q2/(Q2+R2)")
worksheet.write(1, 14, "=2*((M2*N2)/(M2+N2))")
worksheet.write(1, 15, "=COUNTIFS(D:D,\"*false*\", C:C, \"*false*\")")
worksheet.write(1, 16, "=COUNTIFS(D:D,\"*true*\", C:C, \"*true*\")")
worksheet.write(1, 17, "=COUNTIFS(D:D,\"*true*\", C:C, \"*false*\")")
worksheet.write(1, 18, "=COUNTIFS(D:D,\"*false*\", C:C, \"*true*\")")

worksheet.write(4, 11, "=(P5+Q5)/(P5+Q5+R5+S5)")
worksheet.write(4, 12, "=Q5/(Q5+S5)")
worksheet.write(4, 13, "=Q5/(Q5+R5)")
worksheet.write(4, 14, "=2*((M5*N5)/(M5+N5))")
worksheet.write(4, 15, "=COUNTIFS(D:D,\"*false*\", B:B, \"*false*\")+COUNTIFS(D:D,\"*none*\", B:B, \"*false*\")")
worksheet.write(4, 16, "=COUNTIFS(D:D,\"*true*\", B:B, \"*true*\")")
worksheet.write(4, 17, "=COUNTIFS(D:D,\"*true*\", B:B, \"*false*\")")
worksheet.write(4, 18, "==COUNTIFS(D:D,\"*false*\",B:B, \"*true*\")+COUNTIFS(D:D,\"*none*\",B:B, \"*true*\")")

worksheet.write(7, 11, "=(P8+Q8)/(P8+Q8+R8+S8)")
worksheet.write(7, 12, "=Q8/(Q8+S8)")
worksheet.write(7, 13, "=Q8/(Q8+R8)")
worksheet.write(7, 14, "=2*((M8*N8)/(M8+N8))")
worksheet.write(7, 15, "=COUNTIFS(D:D,\"*false*\",E:E, \"*false*\")+COUNTIFS(D:D,\"*none*\",E:E, \"*false*\")")
worksheet.write(7, 16, "=COUNTIFS(D:D,\"*true*\", E:E, \"*true*\")")
worksheet.write(7, 17, "=COUNTIFS(D:D,\"*true*\", E:E, \"*false*\")")
worksheet.write(7, 18, "=COUNTIFS(D:D,\"*false*\",E:E, \"*true*\")+COUNTIFS(D:D,\"*none*\",E:E, \"*true*\")")

row = 1
col = 0
logicOutput = open("output.txt", "r")
for predicate in logicOutput:
	if int(col) == 4:
		worksheet.write(row, col, "=IF(B"+str(row+1)+"<>C"+str(row+1)+",IF(EXACT(C"+str(row+1)+",$J$1),B"+str(row+1)+",C"+str(row+1)+"),B"+str(row+1)+")")
		col = 0
		row = row+1
	worksheet.write(row, col, predicate)
	col = col + 1
workbook.close()


